#include <Bond.h>
// #include <StringTools.h>
#include <algorithm>
#include <vectornumerics.h>

// #define BOND_DEBUG

// return indices of neighouring atom for given index
Vec<unsigned int>
getNeighbours(unsigned int n, const Vec<Bond>& bonds) 
{

#ifdef BOND_DEBUG
  cout << "Starting getNeighours! " << n + 1 << endl;
#endif
  Vec<unsigned int> result;
  for (unsigned int i = 0; i < bonds.size(); ++i) {
    ASSERT(getFirst(bonds[i]) != getSecond(bonds[i]));
    unsigned int id1 = getFirst(bonds[i]);
    unsigned int id2 = getSecond(bonds[i]);
    if (id1 == id2) {
      cerr << "Strange bond: " << i + 1 << " " << bonds[i] << endl;
      continue; 
    }
    if (id1 == n) {
      bool found = false;
      for (unsigned int j = 0; j < result.size(); ++j) {
	if (result[j] == id2) {
	  found = true;
	  break;
	}
      }
      if (!found) {
	result.push_back(id2);
      }
    }
    else if (id2 == n) {
      bool found = false;
      for (unsigned int j = 0; j < result.size(); ++j) {
	if (result[j] == id1) {
	  found = true;
	  break;
	}
      }
      if (!found) {
	result.push_back(id1);
      }
    }    
  }
  return result;
}

/**
 * returns unique list of all atom indices which are occuring in bonds
 */
Vec<unsigned int>
getUniqBondedList(const Vec<Bond>& bonds) {
  Vec<unsigned int> result(2 * bonds.size());
  unsigned int pc = 0;
  for (unsigned int i = 0; i < bonds.size(); ++i) {
    ASSERT(pc < result.size());
    result[pc++] = getFirst(bonds[i]);
    ASSERT(pc < result.size());
    result[pc++] = getSecond(bonds[i]);
  }
  sort(result.begin(), result.end());
  result = uniqueSet(result);
#ifdef BOND_DEBUG
  cout << "getUniqBondedList called with: " << bonds << endl;
  cout << "Result: " << result << endl;
#endif
  // POSTCOND(!containsDuplicates(result));
  return result;
}

/* return list with neighbour info */
Vec<Vec<unsigned int> >
getNeighbourList(const Vec<Bond>& bonds, unsigned int defVal)
{
  if (bonds.size() == 0) {
    return Vec<Vec<unsigned int> >(); // return empty data structure
  }
  Vec<unsigned int> row(5, defVal);
  Vec<unsigned int> uniqList = getUniqBondedList(bonds);
  Vec<Vec<unsigned int> > result(uniqList.size(), row);
//    for (unsigned int i = 0; i < bonds.size(); ++i) {
//      unsigned int id1 = getFirst(bonds[i]);
//      // check if id found so far:
//      bool found = false;
//      for (unsigned int j = 0; j < result.size(); ++j) {
//        ASSERT(result[j].size() > 0);
//        if (result[j][0] == id1) {
//  	found = true;
//  	break;
//        }
//      }
//      if (!found) {
//        result.push_back(row);
//        result[result.size() - 1][0] = id1;
//      }
//      unsigned int id2 = getSecond(bonds[i]);
//      // check if id found so far:
//      found = false;
//      for (unsigned int j = 0; j < result.size(); ++j) {
//        ASSERT(result[i].size() > 0);
//        if (result[j][0] == id2) {
//  	found = true;
//  	break;
//        }
//      }
//      if (!found) {
//        result.push_back(row);
//        result[result.size() - 1][0] = id2;
//      }
//    }
  // now fill neighbour list:
  for (unsigned int i = 0; i < result.size(); ++i) {
    ASSERT(result[i].size() > 0);
    result[i][0] = uniqList[i];
    Vec<unsigned int> neighbours = getNeighbours(result[i][0], bonds);
    for (unsigned int j = 0; j < neighbours.size(); ++j) {
      if ((j+1) >= result[i].size()) {
	cerr << "Too large number of neighbours in line " << i << " : " 
	     << neighbours << endl;
	break;
      }
      result[i][j+1] = neighbours[j];
    }
  }
  return result;
}




/**
 * returns index in which atom n is either one of two atoms in bond
 */
unsigned int
findFirstIndex(unsigned int n, const Vec<Bond>& bonds)
{
  for (unsigned int i = 0; i < bonds.size(); ++i) {
    if ( isInBond(n, bonds[i]) ) {
      return i;
    }
  }
  return bonds.size();
}

unsigned int
findFirstIndex(unsigned int n, unsigned int m,
               const Vec<Bond>& bonds)
{
  for (unsigned int i = 0; i < bonds.size(); ++i) {
    if ( isInBond(n, m, bonds[i]) ) {
      return i;
    }
  }
  return bonds.size();
}

/**
 * shifts all indices y adding "shift"
 */
void
shiftBonds(Vec<Bond>& bonds, int shift) {
  for (unsigned int i = 0; i < bonds.size(); ++i) {
     ASSERT((static_cast<int>(getFirst(bonds[i])) + shift >= 0)
            && (static_cast<int>(getSecond(bonds[i])) + shift >= 0));
    unsigned int newFirst = static_cast<unsigned int>(getFirst(bonds[i]) 
                                                      + shift);
    unsigned int newSecond = static_cast<unsigned int>(getSecond(bonds[i]) 
                                                       + shift);
    //    Bond& b = bonds[i];
    setFirst(bonds[i], newFirst);
    setSecond(bonds[i], newSecond);
//      ASSERT((getFirst(bonds[i]) == newFirst)
//             && (getSecond(bonds[i]) == newSecond));
  }
}

/** 
 * convert internal bond order to mol2 file bond order string
 */
string
bondOrderToString(unsigned int n)
{
  /* if (n <= BOND_ORDER_MAXNORMAL) {
    return uitos(n);
    }
  */
  switch (n) {
  case 0:
    return string("0");
    break;
  case 1:
    return string("1");
    break;
  case 2:
    return string("2");
    break;
  case 3:
    return string("3");
    break;
  case BOND_ORDER_AR: return BOND_STRING_AR;
    break;
  case BOND_ORDER_AM: return BOND_STRING_AM;
    break;
  default:
    break;
  }
  return BOND_STRING_UNK;
}

unsigned int
myatoui(char c) {
  switch(c) {
  case '0': return 0;
  case '1': return 1;
  case '2': return 2;  
  case '3': return 3;
  case '4': return 4;
  case '5': return 5;
  case '6': return 6;
  case '7': return 7;
  case '8': return 8;
  case '9': return 9;
  default:
    ASSERT(false); // should never be here
    break;
  }
  return 999;
}

/** 
 * convert string to bond order
 */
unsigned int
stringToBondOrder(string name)
{
  if ((name.size() == 1) && (isdigit(name[0]))) {
    return myatoui(name[0]);
  }
  // name = trimWhiteSpaceFromString(name);
  // try again:
  if ((name.size() == 1) && (isdigit(name[0]))) {
    return myatoui(name[0]);
  }
  if (name.compare(BOND_STRING_AM) == 0) {
    return BOND_ORDER_AM;
  }
  else if (name.compare(BOND_STRING_AR) == 0) {
    return BOND_ORDER_AR;
  }
  return BOND_ORDER_UNK; // unknown bond order string
}

