\name{pmultirun.complementarity.highestZ.matrixbias}
\title{
Method for determining the statistical significance of over-represented or diagonally arrange nucleotide covaration patterns. Can be used for predicting RNA-RNA interaction candidates.
}
\description{
The method computes P-values for two distinct  
}
\usage{
pmultirun.complementarity.highestZ.matrixbias(file1, file2, idRange = NULL, iterations = 200, gu.allowed = TRUE, pLim = 0.05, shuffle = FALSE, verboseLevel = 0, transform.z = FALSE, pMethod = "binom", matrixFile = NULL, complFractionMin = 0.8, nonGapFractionMin = 0.6, outputSep = "\n", compute.diag = FALSE, combine.p.method = "tpms", antidiag = TRUE, symmetric.triangle.only = FALSE, seqVec = NULL, votingMode = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file1}{
Filename to a "multi-FASTA" formatted file or list multiple sequence alignment according to the (now legacy) Biostrings alignment format. The format is identical to ASCII text files generated by Galaxy corresponding to several multiple sequence alignments. In this format, the text output of different multiple sequence alignments is concatenated, seperated by an empty line.
}
\item{file2}{
Filename to a second set of multiple sequence alignments; either a "multi-FASTA" formatted file or list multiple sequence alignment according to the (now legacy) Biostrings alignment format. The format is identical to ASCII text files generated by Galaxy corresponding to several multiple sequence alignments. In this format, the text output of different multiple sequence alignments is concatenated, seperated by an empty line.
}
  \item{idRange}{
The idRange describes the multiple sequence alignments from both files that should be considered. Example: 2:7 would consider multiple sequence alignments 2 to 7 from both input files.
}
  \item{iterations}{
Specify number of iterations for the shuffling method.
}
  \item{gu.allowed}{
If true, consider GU base pairs for determining covariation.
}
  \item{pLim}{
Specifies the P-value limit, corresponding to which alignment column pairs are considered to be covarying. 
}
  \item{shuffle}{
If true, shuffle first input sequence set before start of P-value computation. Could be used as a control.
}
  \item{verboseLevel}{
Determine how verbose the output should be. 0: silent, greater zero: more verbose. 
}
  \item{transform.z}{
If true, compute z-scores from P-values before further processing.
}
  \item{pMethod}{
Method for determining the P-value for two alignment columns to be covarying. Default: "binom" for binomial test. 
}
  \item{matrixFile}{
If a character string is specified, the computed covariation matrix is written to that file.
}
  \item{complFractionMin}{
Minimum fraction of nucleotides that have to be complementary in order to be potential candidates of covariation.
}
\item{nonGapFractionMin}{
Minimum fraction of sequences, that have for a certain column pair a nucleotide character at both positions.
}
  \item{outputSep}{
Seperator for output format. Default: newline.
}
  \item{compute.diag}{
If true, also perform P-value computation corresponding to an anti-diagonal of observed alignment column pairs.
}
  \item{combine.p.method}{
Method for combining P-values. Default: tpms : a hybrid method consisting of the truncated power method and the Method of Simes.
}
  \item{antidiag}{
If true, also perform computation of P-value corresponding to the bias in anti-diagonal arrangement of covarying alignment column pairs.
}
  \item{symmetric.triangle.only}{
Set to true for intra-sequence covariation (both alignments correspond to the same sequence alignment. Currently experimental.
}
  \item{seqVec}{
   A vector of considered multiple sequence alignment blocks. Example: c(2,5,7) would only perform P-value computations for the second, fifth and seventh multiple sequence alignments provided in the input files.
}
  \item{votingMode}{
If true, perform voting for RNA or DNA interaction mode. Currently experimental. 
}
}
\details{
This method is the underlying function of the CovStat method that is being used for estimate the statistical significance of nucleotide covariation patterns observed in alignment column pairs. The easiest way to use this function is to use the wrapper Perl script called "covstat", located in the directoy bin (or inst/bin) of the covstat package.
}
\value{
Generates as output P values corresponding to over-representation of covariation, arrangement of covarying alignment column pairs in an anti-diagonal fashion and a combination of both of these P-values. This is computed for the provided input alignments as well as the reverse-complementary of both input alignments.
}
\references{
Bindewald E and Shapiro B.A. : Computational detectin of abundant long-range nucleotide covariation in Drosophila genomes. RNA. (Submitted).  
}
\author{
Eckart Bindewald
}


\examples{
test.pmultirun.complementarity.highestz.matrixbias.tRNA()
}

