# returns true if c == '.' or c == '-'
is.gap <- function(c) {
	result <- FALSE
        if (nchar(c) > 1) {
         # check if string consists of only gaps
          result <- TRUE
          for (i in 1:nchar(c)) {
            if (!is.gap(substr(c,i,i))) {
             result <- FALSE  
             break
            }
          }
        } else {
 	 if ((c == '.') | (c == '-')) {
		result <- TRUE
	 }
        }
	result
}

test.is.gap <- function() {
	checkTrue(is.gap("."))
	checkTrue(is.gap("-"))
	checkTrue(!is.gap("A"))
	checkTrue(!is.gap("-A"))
	checkTrue(is.gap("---"))
	checkTrue(is.gap("-.-"))
}

hasOneGap <- function(c1, c2) {
 (is.gap(c1) && (!is.gap(c2))) ||  (!is.gap(c1) && (is.gap(c2)))
}
