# returns true, if two nucleotide characters are Watson-Crick complemetary (possible also allowing G-U or G-T
# ignore case
# both U or T are OK
# also can check sequences
is.complementary <- function(c1, c2, gu.allowed=FALSE, reverse=FALSE, singleGapOK=FALSE, doubleGapOK=FALSE) {
	stopifnot(nchar(c1) == nchar(c2))
	if (nchar(c1) == 1) {
		c1 <- toupper(c1)
		c2 <- toupper(c2)
		if (c1 == "T") {
			c1 <- "U"
		} 
		if (c2 == "T") {
			c2 <- "T"
		}
		result <- FALSE
		if (c1 > c2) {
			result <- is.complementary(c2, c1, gu.allowed)
		} else if (c1 < c2) {
			if (c2 == "T") {
				c2 <- "U" # just for internal use
			}
			if (c1 == "A") {
				if (c2 == "U") {
					result <- TRUE
				}
			} else if (c1 == "C") {
				if (c2 == "G") {
					result <- TRUE
				}
			} else if (c1 == "G") {
				if ((gu.allowed) & (c2 == "U")) {
					result <- TRUE
				}
			}
		}
	} else { # case of comparing whole strings
		result <- TRUE
                countFound <- 0
		for (i in 1:nchar(c1)) {
			id2 <- i
			if (reverse) { # take reverse of second string
				id2 <- nchar(c2) - i + 1
			}
			cs1 <- substr(c1, i,i)
                        cs2 <- substr(c2,id2,id2)
			if (!is.complementary(cs1, cs2, gu.allowed=gu.allowed)) {
                           if (! ((doubleGapOK && is.gap(cs1) && is.gap(cs2)))) {
                            if (! (singleGapOK && hasOneGap(cs1, cs2)) ) {
                             result <- FALSE
                             break
                            }
                           }
			} else {
                          countFound <- countFound + 1
                        }
		}
             if (countFound == 0) {
                result <- FALSE # for special case of pure gap columns
             }
	}
	result
}

# test function for is.complementary
test.is.complementary <- function() {
	checkTrue(is.complementary("A", "U"))
	checkTrue(is.complementary("A", "T"))
	checkTrue(is.complementary("U", "A"))
	checkTrue(is.complementary("T", "A"))
	checkTrue(!is.complementary("G", "A"))
	checkTrue(!is.complementary("G", "U"))
	checkTrue(!is.complementary("G", "T"))
	checkTrue(is.complementary("G", "U", gu.allowed=TRUE))
	checkTrue(is.complementary("G", "T", gu.allowed=TRUE))
	checkTrue(is.complementary("G", "C"))
	checkTrue(!is.complementary("C", "A"))
	checkTrue(is.complementary("ACGU", "UGCA")) # test words
	checkTrue(is.complementary("ACGT", "TGCA")) # test words
	checkTrue(is.complementary("ACGU", "ACGU", reverse=TRUE))
	checkTrue(is.complementary("ACGT", "ACGT", reverse=TRUE))
	checkTrue(!is.complementary("ACGT", "ACGT", reverse=FALSE))
        checkTrue(!is.complementary("GG", "UU", gu.allowed=FALSE))
        checkTrue(is.complementary("GG", "UU", gu.allowed=TRUE))
        checkTrue(!is.complementary("TGATTGGGTGGG","GGGGGGGGAGGG", gu.allowed=TRUE))
        checkTrue(is.complementary("CCCCCCCCTCCC","GGGGGGGGAGGG", gu.allowed=TRUE))
        checkTrue(is.complementary("CCCCCCCCTCC-","GGGGGGGGAGG-", gu.allowed=TRUE, doubleGapOK=TRUE))
        checkTrue(!is.complementary("CCCCCCCCTCC-","GGGGGGGGAGG-", gu.allowed=TRUE, doubleGapOK=FALSE))
         checkTrue(is.complementary("CCCCCCCCTCC-","GGGGGGGGAGGA", gu.allowed=TRUE, singleGapOK=TRUE, doubleGapOK=FALSE))
         checkTrue(!is.complementary("CCCCCCCCTCC-","GGGGGGGGAGGA", gu.allowed=TRUE, singleGapOK=FALSE, doubleGapOK=FALSE))
        checkTrue(!is.complementary("---","---", gu.allowed=TRUE, doubleGapOK=FALSE))
        checkTrue(!is.complementary("---","---", gu.allowed=TRUE, doubleGapOK=TRUE))
        checkTrue(!is.complementary("---","---", gu.allowed=TRUE, singleGapOK=TRUE, doubleGapOK=TRUE))
        checkTrue(!is.complementary("---","---", gu.allowed=TRUE, singleGapOK=TRUE, doubleGapOK=FALSE))
}

