

#ifndef __STEM_HELP__
#define __STEM_HELP__

#include <iostream>
#include <Vec.h>
#include <Stem.h>
// #include <RankedSolution5.h>
#include <stack>

/** returns true if AU, GC, GU (or T instead of U) 
 * TODO: not hard-coded characters!
 */
bool
isComplementary(char c1, char c2);

/** list of connections of three prime end */
Vec<Stem>
convertConnectionsToStems(const Vec<int>& v, unsigned int minStemLength,
			  const string& s);

/** generates list of connections from stems */
Vec<int>
convertStemsToConnections(const Vec<Stem>& stems,
			  unsigned int nSize);

/** reads Ct file produced by mfold */
void
readCtSingle(istream& is, 
	     Vec<Stem>& stems,
	     string& sequence, 
	     unsigned int minStemLength );

/** reads Ct file produced by mfold */
void
writeCtSingle(ostream& os, 
	      const Vec<Stem>& stems, 
	      const string& sequence);

/** reads combined Ct file produced by mfold */
Vec<Vec<Stem> >
readCtCombined(istream& is, string& sequence,
	       unsigned int minStemLength);

/** reads combined Ct file produced by mfold */
Vec<Vec<Stem> >
readCtCombined(istream& is, Vec<string>& sequences,
	       unsigned int minStemLength);

/** list of connections of three prime end */
Vec<Stem>
generateStemsFromMatrix(const Vec<Vec<double> >& mtx, unsigned int minStemLength,
			double thresh,
			const string& sequence);

/** convert stems to matrix */
Vec<Vec<double> >
generateMatrixFromStems(const Vec<Stem>& stems, unsigned int nSize);

/** convert set of set of stems to matrix. Used for computing consensus secondary structure. */
Vec<Vec<double> >
generateAverageMatrixFromStems(const Vec<Vec<Stem> >& stems, unsigned int nSize);

/**
 * returns sequence which is in FASTA forma 
 */
string
readFasta(istream& is);

/**
 * returns sequence which is in Zuker format
 */
string
readZuker(istream& is);


/**
 * returns set of sequences which is in FASTA forma 
 */
Vec<string>
readMultiFasta(istream& is);

/** reads format in format compatible with STRUCTURELAB */
Vec<Stem>
readStems(istream& is);

/** reads format in format compatible with STRUCTURELAB, several concatenated region files */
Vec<Vec<Stem> >
readMultiStems(istream& is);

/** reads BPSEQ format from Gutell homepage */
void
readBPSeq(istream& is, Vec<Stem>& stems, string& sequence,
	  unsigned int minStemLength);

/** output of region file */
void
writeStems(ostream& os,
	   const Vec<Stem>& stems);

/** writes stems with potential position offset */
void
writeStems(ostream& os,
	   const Vec<Stem>& stems,
	   int indexOffset);

/** write stems */
void
writeStems(ostream& os,
	   const Vec<Stem>& stems,
	   const Vec<Vec<Vec<double> > >& matrices,
	   const Vec<unsigned int>& usedIndices,
	   int indexOffset = 0);

/** write stems in BPL format */
void
writeBPLStems(ostream& os,
	      const string& name,
	      const string& sequence,
	      const Vec<Stem>& stems);

string
readSequence(istream& seqFile);

/** write stems with respect to positions of sequences without gaps */
void
writeStems(ostream& os,
	   const Vec<Stem>& stems,
	   const string& aliSequence);

/** writes matrix readable by S-Plus/R */
void
writeMatrix(ostream& os,
	    const Vec<Vec<double> >& m);

/** writes matrix readable by S-Plus/R */
void
writeMatrixReverse(ostream& os,
		   const Vec<Vec<double> >& m);

/** position of relPos' character in string (skip gaps)
    counting start from zero both relative and absolute
*/
unsigned int
convert2AbsolutePositions(unsigned int relPos,
			  const string& s,
			  char gapChar);

/** generates stem list from sequence */
/* Vec<Stem> 
generateStemsFromSequence(const string& sequence,
			  unsigned int minStemLength,
			  Vec<unsigned int>& histogram,
			  bool guAllowed);
*/

/** generates stem list from sequence */
Vec<Stem> 
generateStemsFromSequence(const string& sequence,
			  unsigned int minStemLength,
			  bool guAllowed);

void
conformSequence(string& s, 
		const string& alphabet,
		char defaultChar);

/** returns fraction of pairwise sequence identity */
double
pairwiseSequenceIdentity(const string& s1, const string& s2);

/** returns fraction of pairwise sequence identity */
double
pairwiseSequenceIdentity(const Vec<string>& s);

/** returns fraction of pairwise sequence identity */
double
pairwiseSequenceIdentity(const string& s1, const string& s2,
			 const Vec<string>& matchRules);

/** returns fraction of pairwise sequence identity */
double
pairwiseSequenceIdentity(const Vec<string>& s,
			 const Vec<string>& matchRules);

/** returns index of stem in stem list that is similar (defined by slack)
    to query stem */
unsigned int
findSimilarStem(const Stem& query,
		const Vec<Stem>& stems,
		unsigned int slack);


/** pkCounter contains number of pseudoknots.
    (1 normal, 2: one pseudoknot etc) */
Vec<Stem>
stemsFromBracketFasta(istream& is, unsigned int& pkCounter);

/** pkCounter contains number of pseudoknots.
    (1 normal, 2: one pseudoknot etc) */
Vec<Stem>
stemsFromBracketFasta(istream& is, unsigned int& pkCounter, unsigned int& length);

Vec<Vec<Stem> >
readRNAsubopt(istream& is, Vec<double>& scores);

void
addStemToMatrix(Vec<Vec<double> >& compMatrix,
		 const Stem& stem,
		double stemWeight);

void
addStemsToMatrix(Vec<Vec<double> >& compMatrix,
		 const Vec<Stem>& referenceStems,
		 double stemWeight);

double
compareStems(unsigned int seqLen,
	     const Vec<Stem>& predStems,
	     const Vec<Stem>& refStems,
	     unsigned int& tp,
	     unsigned int& fp, 
	     unsigned int& tn,
	     unsigned int& fn);

/** givens stems and sequence, return bracket notation. Checks for gaps. */
string
stemsToBracketFasta(const Vec<Stem>& stems, const string& sequence);

/** givens stems and sequence, return bracket notation. */
string
stemsToBracketFasta(const Vec<Stem>& stems, unsigned int len);

/** write all possible stems */
void
entropyStemList(ostream& os, 
		const Vec<Vec<double> >& mat, const string& sequence,
		const Vec<string>& allowedPairs,
		double scoreLimit,
		unsigned int minStemLength,
		double scoreWeight,
		double predictionConfidence);

/** removes nucleotide, adjusts stems accordingly */
void
deletePositionInStems(Vec<Stem>& stems, 
		      string sequence, unsigned int delPos);

/** removes nucleotide, adjusts stems accordingly */
void
insertGapInStems(Vec<Stem>& stems, 
		 string& sequence,
		 unsigned int insPos);

/** returns true if position is part of stem */
bool
isPosInStem(int x, int y, const Stem& stem);

/** returns true if position is part of one of stems */
bool
isPosInStems(int x, int y, const Vec<Stem>& stems);

/** returns number of base pairs */
unsigned int
countNumBasePairs(const Vec<Stem>& stems);

#endif
