#include <generalNumerics.h>
#include <debug.h>
#include <math.h>

double
factorial(int n)
{
  double result = 1.0;
  for (int i = 2; i <= n; ++i) {
    result *= i;
  }
  return result;
}

double
nOverK(int n, int k) 
{
  if (k > n) {
    return 0.0;
  }
  if (k == 1) {
    return static_cast<double>(n);
  }
  if ((k == n) || (k == 0)) {
    return 0.0;
  }
  double result = (factorial(n) / factorial(k)) / factorial(n - k);
  return result;
}

double
lg2(double x)
{
  const double LOG2 = log(2.0);
  if (x <= 0.0) {
    return 0.0;
  }
  return log(x) / LOG2;
}

/** returns logistic function */
double
logistic(double x)
{
  double result = (exp(x) / (1 + exp(x)));
  // ASSERT((result >= 0.0) && (result <= 1.0), exception);
  return result;
}


