#ifndef __MUTUAL_INFORMATION_SCORER__
#define __MUTUAL_INFORMATION_SCORER__

#include <string>
#include <Physical.h>

using namespace std;

class MutualInformationScorer {

 public:

  virtual ~MutualInformationScorer() { }
  
  /** returns (the error corrected) mutual information and an estimate of the small sample noise as a standard deviation */
  virtual Physical computeMutualInformation(const string& s1, 
					    const string& s2) const = 0;
  
  /** computes the information of an alignment column */
  virtual Physical computeInformation(const string& s) const = 0;

};

#endif
