/**********************************************************************
 *                                                                    *
 *       (c) Copyright 2003                                           *
 *       All rights reserved                                          *
 *       Programs written by Jianghui Liu (NJIT)                      *
 *                                                                    *
 *       Permission to use, copy, modify, and distribute this         *
 *       software and its documentation for any purpose and without   *
 *       fee is hereby granted, provided that this copyright          *
 *       notice appears in all copies.   Programmer(s) makes no       *
 *       representations about the suitability of this                *
 *       software for any purpose.  It is provided "as is" without    *
 *       express or implied warranty.                                 *
 *                                                                    *
 *      STABLE VERSION:     10/17/2003                                *
 *      Revised on:         10/16/2003                                *
 *      Revised on:         09/24/2003                                *
 *      Revised on:         09/18/2003                                *
 *      Created on:         08/06/2003                                *
 **********************************************************************/
package RNA;
import java.io.*;
import java.util.*;

public class RNAReader
{
    private BufferedReader in   =  null;
    private String oneLineAhead = null;

    public static final int PLAIN = 2;
    public static final int MATRIX= 1;
    public static final int NEST  = 0;

    /*public static void main(String args[])
    {
        String datafile = "Hs.IRE.DB";
        RNAReader r = new RNAReader(datafile);

        System.out.println(r.getNextRNA().dispRNA());
        System.out.println(r.getNextRNA().dispRNA());
        System.out.println(r.getNextRNA().dispRNA());
    }*/

    public RNAReader()
    {
        in = null;
    }

    public RNAReader(String InputFileName)
    {
        try{
            in = new BufferedReader(new FileReader(InputFileName));
            oneLineAhead = new String("");
        } catch(Exception e) {
            e.printStackTrace();
        }
    }

    public RNA getNextRNA()
    {
        try{
            if( in == null || in.ready() == false)
                return null;
        } catch( Exception e) {
            e.printStackTrace();
        }

        String sequence = null;
        String RNAname  = null;
        String remark   = null;
        String structLine = null;
///#########################################################################
	String conserved = null;
//#########################################################################
        StringBuffer partial = new StringBuffer();

        String line = "";
        if( oneLineAhead.length() != 0)
            line = new String(oneLineAhead);

        try{
            while(line.length() == 0 || line.charAt(0) != '>') {
                if( (line = in.readLine()) == null) {
                    in.close();
                    return null;
                }
            }

            // get RNA name and remark
            String[] header = line.split("[\\s+]", 2);   //changed by mugdha to remove the bug in annotation;
            if( header.length > 0){
                RNAname = header[0];
                RNAname = RNAname.substring(1, RNAname.length());
            } else
                RNAname = "Unknown RNA";

            if( header.length > 1)
                remark = header[header.length-1];
            else
                remark = "";

            // get RNA sequence data
            sequence = in.readLine();
            structLine=in.readLine();
//##################################NEW##############################################
	    in.mark(1000);
	    conserved = in.readLine();
	    if(conserved != null){
	    if((conserved.length()!=0)&&(conserved.charAt(0) != '>')){
               // System.out.println("conserved is in getnext :"+conserved);
               // System.out.println("length is:"+conserved.length());
            }
	    }
	    if(conserved!=null){
	    if((conserved.length()!= 0) && (conserved.charAt(0) == '>')){
	    	in.reset();	
	    }
	    }

//######################################################################################
        } catch(IOException e) {
            e.printStackTrace();
        };

        return new RNA(RNAname, sequence.toUpperCase(), structLine, remark,conserved);
    }

//#############################################NEW for CSFS##################################################################
    public RNA getNextRNAforcsfs()
    {
        try{
            if( in == null || in.ready() == false)
                return null;
        } catch( Exception e) {
            e.printStackTrace();
        }

        String sequence = null;
        String RNAname  = null;
        String remark   = null;
        String structLine = null;
	int seq_no;   //#####new
	int str_no;  //#######new
	String [] header = new String[5]; //#######NEW

        StringBuffer partial = new StringBuffer();

        String line = "";
        if( oneLineAhead.length() != 0)
            line = new String(oneLineAhead);

        try{
            while(line.length() == 0 || line.charAt(0) != '>') {
                if( (line = in.readLine()) == null) {
                    in.close();
                    return null;
                }
            }

            // get RNA name and remark
            header = line.substring(1).split("[\\s+]", 4);//##########change to 4 from 3
            if( header.length > 0){
                RNAname = header[2];
                RNAname = RNAname.substring(0, RNAname.length());
            } else
                RNAname = "Unknown RNA";

            if( header.length > 1)
                remark = header[header.length-1];
            else
                remark = "";

            // get RNA sequence data
            sequence = in.readLine();
            structLine=in.readLine();
        } catch(IOException e) {
            e.printStackTrace();
        };

	seq_no = Integer.parseInt(header[0]);
	str_no = Integer.parseInt(header[1]);

        return new RNA(RNAname, sequence.toUpperCase(), structLine, remark,seq_no,str_no);
    }
//####################################################################################################################################



    public static RNA getRNA(BufferedReader rd)
    {
        return getRNA_nest(rd);
    }

///################################IF FACTOR FILE IS PROVIDED#######################################################################
    public static RNA getRNA(BufferedReader rd, String factor_file)
    {
        return getRNA_nest(rd,factor_file);
    }
//##################################################################################################################################
    //---------------------------------------------------------
    // This is read in an RNA in parenthesis nested format as:
    //   >NM_000032:1-52 Homo sapiens aminolevulinate
    //   CACCTGTCATTCGTTCGTCCTCAGTGCAGGGCAACAGGACTTTAGGTTCAAG
    //   .(((((...((((((.(((((......)))))))).)))...))))).....
    //---------------------------------------------------------
    private static RNA getRNA_nest(BufferedReader in)
    {
        String sequence = null;
        String RNAname  = null;
        String remark   = null;
        String structLine  = null;
//################################################################################################
	String conserved = null;
//###############################################################################################
        String line = null;
        try {
            while( ((line = in.readLine()) != null) && 
                    (line.length() == 0 || line.charAt(0) != '>'));

            if( line == null)
                return null;

            // get RNA name and remark
            String[] header = line.split("[\\s+]", 2);
            //System.out.println("segments: " + header.length);
            if( header.length > 0)
                RNAname = header[0];
            else
                RNAname = "Unknown RNA";

            if( header.length > 1){
                remark = header[header.length-1];
                //System.out.println("annotate: " + remark);
            } else
                remark = "";

            // get RNA sequence
            sequence = in.readLine();
            structLine = in.readLine();
	    //################################################################################
	    conserved = in.readLine();
	    if((conserved != null)&&(conserved.length()!=0)&&(conserved.charAt(0) != '>')){
		System.out.println("conserved is :"+conserved);
		System.out.println("length is:"+conserved.length());
	    }
	    else{
		System.out.println("Conserved in null");
		conserved = null;
	    }
	    //###############################################################################
        } catch(IOException e) {
            e.printStackTrace();
        }
	if(conserved==null){
        	return new RNA(RNAname.substring(1,RNAname.length()), sequence.toUpperCase(), structLine, remark,null);
	}
	else{

        	return new RNA(RNAname.substring(1,RNAname.length()), sequence.toUpperCase(), structLine, remark,conserved);
	}
    }

//#################NEW FOR reading the factor of conservation#########################################################################
//

    private static RNA getRNA_nest(BufferedReader in, String factor_file)
    {
        String sequence = null;
        String RNAname  = null;
        String remark   = null;
        String structLine  = null;
//################################################################################################
	String conserved = null;
	double[]  factors = new double[1000];
	int i=0;
//###############################################################################################
        String line = null;
        try {
            while( ((line = in.readLine()) != null) && 
                    (line.length() == 0 || line.charAt(0) != '>'));

            if( line == null)
                return null;

            // get RNA name and remark
            String[] header = line.split("[\\s+]", 2);
            //System.out.println("segments: " + header.length);
            if( header.length > 0)
                RNAname = header[0];
            else
                RNAname = "Unknown RNA";

            if( header.length > 1){
                remark = header[header.length-1];
                //System.out.println("annotate: " + remark);
            } else
                remark = "";

            // get RNA sequence
            sequence = in.readLine();
            structLine = in.readLine();
	    //################################################################################
	    conserved = in.readLine();
	    if((conserved != null)&&(conserved.length()!=0)&&(conserved.charAt(0) != '>')){
		System.out.println("conserved is :"+conserved);
		System.out.println("length is:"+conserved.length());
	    }
	    //###############################################################################
        } catch(IOException e) {
            e.printStackTrace();
        }
///##################################read the factors##############################################################
	
	try{
		BufferedReader fin = new BufferedReader(new FileReader(factor_file));
		while (((line = fin.readLine())!=null)&& (line.length() != 0)){
			factors[i] = Double.valueOf(line).doubleValue();	
		//	System.out.println("\nfactor : "+factors[i]+"  ");
			i++;
		}
		if(i<sequence.length()){
			while(i<sequence.length()){
				factors[i] = 0;
				i++;
			}
		}
	}catch(IOException e){
		e.printStackTrace();
	}

///################################################################################################################
        return new RNA(factors,RNAname.substring(1,RNAname.length()), sequence.toUpperCase(), structLine, remark,conserved);
    }
//########################################################################################################################

    //-------------------------------------------
    // This function will accept RNA format as:
    // >RNA: query_rna
    // >sequence:
    // GAAGGGUUCC
    // >bonds:
    // 1    10    1
    // 2    8    1
    //--------------------------------------------
    private static RNA getRNA_plain(BufferedReader in)
    {
        String sequence = null;
        String RNAname  = null;
        String remark   = null;
        int[] pairs     = null;

        StringBuffer partial = new StringBuffer();
        String line = null;

        try {
            while( ((line = in.readLine()) != null) && 
                   (line.length() == 0 || line.charAt(0) != '>'));

            if( line == null)
                return null;

            // get RNA name and remark
            String[] header = line.split("[\\s+]", 2);
            System.out.println("segments: " + header.length);
            if( header.length > 0)
                RNAname = header[0];
            else
                RNAname = "Unknown RNA";

            if( header.length > 1){
                remark = header[header.length-1];
                System.out.println("annotate: " + remark);
            } else
                remark = "";

            // skip gabage line(s)
            while( ((line = in.readLine()) != null) && 
                   (line.length() == 0 || line.charAt(0) != '>'));

            if( line == null)
                return null;

            // get RNA sequence
            line = in.readLine();
            while( line.length() != 0 && line.charAt(0) != '>') {
                partial.append(line);
                if( (line = in.readLine()) == null)
                {
                    sequence = partial.toString();

                    pairs = new int[sequence.length()];
                    for(int i=0; i<pairs.length;  i++)
                        pairs[i] = -1;

                    return new RNA(RNAname, sequence.toUpperCase(), pairs, remark);
                }
            }
            sequence = partial.toString();

            pairs = new int[sequence.length()];
            for(int i=0; i<pairs.length; i++)
                pairs[i] = -1;


            // skip gabage line(s)
            while( line.length() == 0 || (line.charAt(0) != '>'))
            {
                if( (line = in.readLine()) == null)
                    return new RNA(RNAname, sequence.toUpperCase(), pairs, remark);
            }

            line = in.readLine();
            StringTokenizer t = new StringTokenizer(line);
            while( line != null && line.length() != 0)
            {
                t = new StringTokenizer(line);
                int start = Integer.parseInt(t.nextToken());
                int end = Integer.parseInt(t.nextToken());
                int length = Integer.parseInt(t.nextToken());

                for(int i=0; i<length; i++) {
                    pairs[start-1+i] = end-1-i;
                    pairs[end-1-i] = start-1+i;
                }

                line = in.readLine();
            }
        } catch(IOException e) {
            e.printStackTrace();
        }

        return new RNA(RNAname, sequence.toUpperCase(), pairs, remark);
    }


    //---------------------------------------------------------------------
    // !!! Seldomly Used !!!
    // This funciton will deal with dot-matrix format of mfold output
    //---------------------------------------------------------------------
    private static RNA getRNA_Zuker(BufferedReader in)
    {
        String sequence = null;
        String RNAname = null;
        int[] pairs = null;

        StringBuffer partial = new StringBuffer();
        String line = null;
        try {
            line = in.readLine();
            StringTokenizer t = new StringTokenizer(line, "\t");

            RNAname = t.nextToken();
            while( t.hasMoreTokens())
                partial.append(t.nextToken());

            sequence = partial.toString();
            pairs = new int[sequence.length()];
            for(int i=0; i<pairs.length; i++)
                pairs[i] = -1;

            int row = 0;
            while(  (line=in.readLine()) != null) {
                String holder=null;

                StringTokenizer token = new StringTokenizer(line, "\t", true);
                token.nextToken();   // skip ribonucleotide
                token.nextToken();   // skip '\tab' symbol

                for(int col = 0;  col<row; col ++) {
                    if( token.hasMoreTokens()) {
                        holder = token.nextToken();
                        if (holder.equals("\t") != true  && Double.parseDouble(holder) > 0)
                        {
                            pairs[row] = col;
                            pairs[col] = row;
                            if (token.hasMoreTokens())
                                token.nextToken();
                        }
                    }
                }
                row ++;
            }
        }catch(IOException e) {
            e.printStackTrace();
        };

        return new RNA(RNAname, sequence.toUpperCase(), pairs);
    }

    //--------------------------------------------------------------------
    //                        !!!! OBSOLETE !!!!
    // This method will construct a RNA object from given stream in which 
    // data is orgnized in the specified type: plain file or Zuker's marix
    // output.
    //--------------------------------------------------------------------
    public static RNA getRNA(BufferedReader rd, int dataType)
    {
        if( dataType == MATRIX)  // Zuker's dot-plot format
            return getRNA_Zuker(rd);
        else if( dataType == PLAIN)  // plain text format
            return getRNA_plain(rd);
        else if( dataType == NEST)  // parenthsis nested format
            return getRNA_nest(rd);
        else
            return null;
    }
}
